// File: applib.cpp
//
// Description: Source code for the Microsoft Windows NT
//              Class library.
//              This library was written using Borland C++.
//
// Copyright 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software library
//       may be used in compiled form without restrictions.
//       All source rights reserved: Source code to the GUI
//       library can not be distributed (on bulletin boards,
//       or as part of shareware or commercial products)
//       without written permission.
//
//       This software is provided "as is". The user accepts
//       all responsibility for its use.
//

#include "applib.h"

// Specify a window title name here:
char TAppWindow::windowName[] = "  ";

int Application::showWindowFlag = 0;

// Define the following constant if you want background
// processing (e.g., this is required for 3D Chess):

#define TIMER 1

int Application::processEventMessages(void)
{
    MSG eventMessage;
    // Keep running until the user kills the program:
    while (GetMessage(&eventMessage, NULL, 0, 0 ))  {
        TranslateMessage(&eventMessage);
        DispatchMessage(&eventMessage);
    }
    return eventMessage.wParam;
}

HANDLE Application::instanceHandle = 0;

void TAppWindow::registerWindow( void )
{
    WNDCLASS wndclass;   // Structure used to register
                         // Windows class.
    wndclass.style = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc = ::WndProc; // window callback
                                      // proc
    wndclass.cbClsExtra = 0;  // don't allocate
                              // extra space
    wndclass.cbWndExtra = sizeof(TAppWindow *);
    wndclass.hInstance  = Application::instanceHandle;
    wndclass.hIcon  = LoadIcon(Application::instanceHandle,
                               "GUIlib");
    wndclass.hCursor= LoadCursor(NULL, IDC_ARROW);
    wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
    wndclass.lpszMenuName  = "MyMenu";
    wndclass.lpszClassName = windowName;

    if (RegisterClass(&wndclass) == 0)
       exit( FALSE ); // register failed
}

static int i_timer = 0;

int PASCAL DefaultTimer(HWND /* hWnd */ , 
                        WORD /* iMessage */ ,
                        WORD /* wParam */ ,
                        LONG /* lParam */)
{
    TAppWindow *current_window =
        Application::get_TAppWindow();
    // MessageBeep(1);
    current_window->idle_proc();
    return 0;
}

// Do not create unless previously registered.
TAppWindow::TAppWindow( void )
{
    hWnd = CreateWindow(windowName,
                        windowName,
                        WS_OVERLAPPEDWINDOW,
                        40, 40,     // position
                        400, 400,   // size
                        NULL,
                        NULL,
                        Application::instanceHandle,
                        NULL );

    if (hWnd == 0)
        exit( FALSE );   // Failed to create a window!!

#ifdef TIMER
    FARPROC lpfnDefaultTimer =
        MakeProcInstance((FARPROC)DefaultTimer,
                         Application::instanceHandle);

    // Set up a 300 millisecond timer:
    if (!(i_timer=SetTimer(NULL, 0, 300, lpfnDefaultTimer)))
    {
       MessageBox(hWnd,"No available timer.","applib",
                  MB_ICONEXCLAMATION | MB_OK);
       exit(0);
    }
#endif

    Application::set_TAppWindow(this);

    ShowWindow(hWnd, Application::showWindowFlag);
    UpdateWindow(hWnd);
    in_scrolling_text_mode = 0;
    redraw_both_text_and_graphics = 0;
    bottom_text_clip = 0;
    backgroundBrush = GetStockObject(WHITE_BRUSH);
    blackBrush = GetStockObject(BLACK_BRUSH);
}

// User application utility functions (external to Windows):

void TAppWindow::plot_line(int x1, int y1, int x2, int y2)
{  POINT old_loc;
    if (current_hDC != (HDC)NULL)
    {
        MoveToEx(current_hDC, x1, y1, &old_loc);
        LineTo(current_hDC, x2, y2);
    }
}
void TAppWindow::plot_string(int x, int y, char *cp)
{
    if (current_hDC != (HDC)NULL)
    {
        TextOut(current_hDC, x, y - 12, cp, strlen(cp));
    }
}
void TAppWindow::plot_rect(int top, int right,
                           int bottom, int left)
{
    plot_line(left, top, right, top);
    plot_line(right, top, right, bottom);
    plot_line(right, bottom, left, bottom);
    plot_line(left, bottom, left, top);
}
void TAppWindow::erase_rect(int top, int right,
                            int bottom, int left)
{
    if (current_hDC != (HDC)NULL)
    {
       SelectObject(current_hDC, backgroundBrush);
       SelectObject(current_hDC, GetStockObject(NULL_PEN));
       Rectangle(current_hDC, left, top, right, bottom);
       SelectObject(current_hDC, GetStockObject(BLACK_PEN));
    }
}

void TAppWindow::clear_display()
{
    erase_rect(0, 0, 1024, 1024);
    // force a redraw via user's update method:
    InvalidateRect(hWnd,NULL,TRUE);
}

void TAppWindow::redraw_display()
{
    // force a redraw via user's update method:
    InvalidateRect(hWnd,NULL,TRUE);
}

void TAppWindow::Paint( void )
{
    PAINTSTRUCT ps;
    HDC hDC;
    hDC = BeginPaint( hWnd, &ps );
    // Save this hDC for other member functions:
    current_hDC = hDC;
    if (in_scrolling_text_mode == 0 ||
        redraw_both_text_and_graphics == 1)
    {
       update_display();  // User defined callback
    }
    if (bottom_text_clip > 0  &&
        (in_scrolling_text_mode == 1 ||
         redraw_both_text_and_graphics == 1))
    {
      HRGN hClipRgn =
         CreateRectRgn(left_text_clip+2, top_text_clip+2,
                       right_text_clip-2, bottom_text_clip-2);
      SelectClipRgn(current_hDC, hClipRgn);

      RECT r;
      SetRect(&r, left_text_clip+2, top_text_clip+2,
              right_text_clip-2,bottom_text_clip-2);
      FillRect(current_hDC, &r, backgroundBrush);

      // Refresh any user scrolling text:
      int next = current_ring_buffer_start;
      for (int i=0; i<number_of_saved_lines; i++)
      {
        next--;
        if (next < 0) next = number_of_saved_lines - 1;
        plot_string(left_text_clip+3,
                    bottom_text_clip - 4 -
                       i*(string_height(" ")+2),
                    saved_text[next]);
      }
      DeleteObject(hClipRgn);
      hClipRgn = CreateRectRgn(0, 0, 1024, 1024);
      SelectClipRgn(current_hDC, hClipRgn);
      if (redraw_both_text_and_graphics == 1)
      {
        plot_rect(top_text_clip, right_text_clip,
                  bottom_text_clip, left_text_clip);
      }
      DeleteObject(hClipRgn);
    }
    EndPaint( hWnd, &ps );
    current_hDC = (HDC)NULL;
}

// Default Dialog About box:

int PASCAL DefaultAboutBox(HWND hWnd,
                           WORD iMessage,
                           WORD wParam,
                           LONG /* lParam */)
{
    switch (iMessage)
    {
        case WM_INITDIALOG:
            return TRUE;
        case WM_COMMAND:
            if (wParam == 1002) {  // OK button hit
                EndDialog(hWnd, 0);
                return TRUE;
            } else {
                return FALSE;
            }
        default:
            return FALSE;
    }
}

// Default Dialog Edit box:

static char FAR cpEdit[256];
static char FAR cpPrompt[128];
static char FAR cpExtension[14];

int PASCAL DefaultEditBox(HWND hWnd,
                          WORD iMessage,
                          WORD wParam,
                          LONG /* lParam */)
{
    switch (iMessage)
    {
        case WM_INITDIALOG:
            SetDlgItemText(hWnd, 102, cpEdit);
            return TRUE;
        case WM_COMMAND:
            if (wParam == 1002) {  // OK button hit
                for (int i=0; i<256; i++)
                    cpEdit[i] = '\0';
                GetDlgItemText(hWnd, 102, &(cpEdit[0]), 80);
                EndDialog(hWnd, 0);
                return TRUE;
            } else {
                return FALSE;
            }
        default:
            return FALSE;
    }
}


static char FAR szFileSpec[32];
static char FAR szFileName[100];
static WORD FAR wFileAttribute;

int PASCAL DefaultFileInBox(HWND hWnd,
                            WORD iMessage,
                            WORD wParam,
                            LONG lParam)
{
     switch (iMessage)
     {
        case WM_INITDIALOG:
            // set up prompt:
            SetDlgItemText(hWnd, 102, cpPrompt);
            szFileSpec[0] = '*'; szFileSpec[1] = '.';
            if (cpExtension[0] == '\0')
            {
                  szFileSpec[2] = '*';
            } else
            {
                  for (int i=0; cpExtension[i] != '\0'; i++)
                  {
                      szFileSpec[i+2] = cpExtension[i];
                      szFileSpec[i+3] = '\0';
                  }
             }
            wFileAttribute = 0x4010;
            SendDlgItemMessage(hWnd, 103,
                               EM_LIMITTEXT, 80, 0L);
            DlgDirList(hWnd, szFileSpec, 104,
                       105, wFileAttribute);
            SetDlgItemText(hWnd, 103, szFileName);
            return TRUE;
        case WM_COMMAND:
            if (wParam == 1002)  // OK button hit
            {
                for (int i=0; i<256; i++)
                    cpEdit[i] = '\0';
                GetDlgItemText(hWnd, 103, &(cpEdit[0]), 80);
                EndDialog(hWnd, 0);
                return TRUE;
            } else
            if (wParam == 104) //  List box
            {
                WORD option = HIWORD( lParam);
                if (option == LBN_DBLCLK)
                {
                    if (DlgDirSelectEx(hWnd, szFileName,
                                       99, 104))
                    {
                        strcat(szFileName, szFileSpec);
                        DlgDirList(hWnd, szFileName, 104,
                                   105, wFileAttribute);
                        SetDlgItemText(hWnd, 103, szFileSpec);
                    } else
                    {
                        SetDlgItemText(hWnd, 103, szFileName);
                        SendMessage(hWnd, WM_COMMAND, 1002, 0L);
                    }
                    return TRUE;
                }
                if (option == LBN_SELCHANGE)
                {
                    if (DlgDirSelectEx(hWnd, szFileName,
                                       99, 104))
                    {
                        strcat(szFileName, szFileSpec);
                    }
                    SetDlgItemText(hWnd, 103, szFileName);
                    return TRUE;
                }
                return TRUE;
            }
            else {
                return FALSE;
            }
        default:
            return FALSE;
    }
    return FALSE;  // unreachable statement
}

int PASCAL DefaultFileOutBox(HWND hWnd,
                             WORD iMessage,
                             WORD wParam,
                             LONG lParam)
{
    switch (iMessage)
    {
        case WM_INITDIALOG:
            // set up prompt:
            SetDlgItemText(hWnd, 102, cpPrompt);
            szFileSpec[0] = '*';
            szFileSpec[1] = '.';
            szFileSpec[2] = '*';
            szFileSpec[3] = '\0';
            szFileName[0] = '\0';
            wFileAttribute = 0x4010;
            SendDlgItemMessage(hWnd, 103,
                               EM_LIMITTEXT, 80, 0L);
            DlgDirList(hWnd, szFileSpec,
                       104, 105, wFileAttribute);
            SetDlgItemText(hWnd, 103, szFileName);
            return TRUE;
        case WM_COMMAND:
            if (wParam == 1002) // OK button hit
            {
                for (int i=0; i<256; i++)
                    cpEdit[i] = '\0';
                GetDlgItemText(hWnd, 103, &(cpEdit[0]), 80);
                EndDialog(hWnd, 0);
                return TRUE;
            } else
            if (wParam == 104) //  List box
            {
                WORD option = HIWORD( lParam);
                if (option == LBN_DBLCLK)
                {
                    if (DlgDirSelectEx(hWnd, szFileName,
                                       99, 104))
                    {
                        strcat(szFileName, szFileSpec);
                        DlgDirList(hWnd, szFileName,
                                   104, 105, wFileAttribute);
                        SetDlgItemText(hWnd, 103, szFileSpec);
                    } else
                    {
                        SetDlgItemText(hWnd, 103, szFileName);
                        SendMessage(hWnd, WM_COMMAND, 1002, 0L);
                    }
                    return TRUE;
                }
                if (option == LBN_SELCHANGE)
                {
                    if (DlgDirSelectEx(hWnd, szFileName,
                                       99, 104))
                    {
                        strcat(szFileName, szFileSpec);
                    }
                    SetDlgItemText(hWnd, 103, szFileName);
                    return TRUE;
                }
                return TRUE;
            }
            else {
                return FALSE;
            }
        default:
            return FALSE;
    }
    return FALSE;  // unreachable statement
}

// For selection from MODAL dialog boxes:
static int theItem;   
const int MAX_LIST_ITEMS = 64;
static LPSTR the_list_items[MAX_LIST_ITEMS];
static int the_number_of_list_items;


// Single List Dialog box:

int PASCAL DefaultListBox(HWND hWnd,
                          WORD iMessage,
                          WORD wParam,
                          LONG /* lParam */)
{  int i;
    switch (iMessage)
    {
        case WM_INITDIALOG:
            for (i=0; i<the_number_of_list_items; i++)
            {
                LPSTR lpStr = &(the_list_items[i][0]);
                SendDlgItemMessage(hWnd,104,LB_ADDSTRING,
                                   0, (LONG)lpStr);
            }
            SetDlgItemText(hWnd, 100, cpPrompt);
            return TRUE;

        case WM_COMMAND:
            if (wParam == 103) {  // Cancel button hit
                    theItem =
                      SendDlgItemMessage(hWnd, 104,
                                         LB_GETCURSEL,0,0L);
                EndDialog(hWnd, FALSE);
                return TRUE;
            } else
            if (wParam == 104) { //  List box
                theItem =
                     SendDlgItemMessage(hWnd, 104,
                                        LB_GETCURSEL,0,0L);
                if (theItem == -1)  return FALSE; // no item
                                                  // selected yet
                EndDialog(hWnd, TRUE);
                return TRUE;
            }
        default:
            return FALSE;
    }
}


static FARPROC lpfnDefaultAboutBox;
static FARPROC lpfnDefaultEditBox;
static FARPROC lpfnDefaultListBox;
static FARPROC lpfnDefaultFileInBox;
static FARPROC lpfnDefaultFileOutBox;

long TAppWindow::WndProc(UINT iMessage,
                         WPARAM wParam,
                         LPARAM lParam)
{
    static int mouse_down_flag = 0;
    switch (iMessage)
    {
    // Menu item:
    case WM_COMMAND:
        if (wParam < 20) do_menu_action(wParam);
        InvalidateRect(hWnd, NULL, TRUE);
        break;
    case WM_CREATE:
        lpfnDefaultAboutBox =
            MakeProcInstance((FARPROC)DefaultAboutBox,
                             Application::instanceHandle);
        lpfnDefaultEditBox = 
            MakeProcInstance((FARPROC)DefaultEditBox,
                             Application::instanceHandle);
        lpfnDefaultListBox = 
            MakeProcInstance((FARPROC)DefaultListBox,
                             Application::instanceHandle);
        lpfnDefaultFileInBox = 
            MakeProcInstance((FARPROC)DefaultFileInBox,
                             Application::instanceHandle);
        lpfnDefaultFileOutBox =
            MakeProcInstance((FARPROC)DefaultFileOutBox,
                             Application::instanceHandle);
        break;
    case WM_PAINT:
        Paint();
        break;
    case WM_LBUTTONDOWN:  // left button is down
        mouse_down_flag = 1;
        mouse_down(LOWORD(lParam), HIWORD(lParam));
        InvalidateRect(hWnd, NULL, TRUE);
        break;
    case WM_MOUSEMOVE:  // left button is down
        if (mouse_down_flag)
        {
           mouse_move(LOWORD(lParam), HIWORD(lParam));
           // FALSE -> do not erase first:
           InvalidateRect(hWnd, NULL, FALSE);
        }
        break;
    case WM_LBUTTONUP:  // left button is down
        mouse_up(LOWORD(lParam), HIWORD(lParam));
        mouse_down_flag = 0;
        InvalidateRect(hWnd, NULL, TRUE);
        break;
    case WM_DESTROY:
        if (i_timer!=0)  KillTimer(NULL, i_timer);
        PostQuitMessage(0);
        break;
    default:
        return DefWindowProc(hWnd, iMessage,
                             wParam, lParam);
    }
    return 0;
}

void TAppWindow::do_about()
{
    DialogBox(Application::instanceHandle,
              "AboutBox",
              hWnd,
              lpfnDefaultAboutBox);
}

void TAppWindow::do_edit(char * /* prompt */ , char *buf)
{
    int len = strlen(buf); if (len > 255) len = 255;
    for (int i=0; i<len; i++)
        cpEdit[i] = buf[i];
    cpEdit[len] = '\0';
    DialogBox(Application::instanceHandle,
              "EditBox",
              hWnd,
              lpfnDefaultEditBox);
    for (i=0; cpEdit[i] != '\0'; i++)
        buf[i] = cpEdit[i];
    buf[i] = '\0';
    return;
}

int TAppWindow::choose_one_from_list(char *prompt,
                                     char **list_items,
                                     int number_of_items)
{   theItem = -12;
    the_number_of_list_items = number_of_items;
    if (the_number_of_list_items > MAX_LIST_ITEMS)
        the_number_of_list_items = MAX_LIST_ITEMS;
    int len = strlen(prompt);
    if (len > 127) len = 127;
    for (int i=0; i<len; i++)
        cpPrompt[i] = prompt[i];
    cpPrompt[len] = '\0';
    for (i=0; i<number_of_items && i < (64 - 1); i++)
        the_list_items[i] = list_items[i];
    DialogBox(Application::instanceHandle,
              "ListBox",
              hWnd,
              lpfnDefaultListBox);

    return theItem;
}

int TAppWindow::choose_one(char *prompt1, char *prompt2)
{
    static char *list[2];
    list[0] = prompt1; list[1] = prompt2;
    return choose_one_from_list("Choose one:", list, 2);
}

void TAppWindow::init_scrolling_text(int top,
                                     int right,
                                     int bottom,
                                     int left)
{
    top_text_clip = top;
    right_text_clip = right;
    bottom_text_clip = bottom;
    left_text_clip = left;
    number_of_saved_lines =
         1 + ((bottom_text_clip - top_text_clip) /
                          string_height(" "));
    if (number_of_saved_lines < 4)
       number_of_saved_lines = 4;
    if (number_of_saved_lines > MAX_TEXT_LINES)
       number_of_saved_lines = MAX_TEXT_LINES;
    current_ring_buffer_start = 0;
    // Allocate storage for saved text lines:
    for (int i=0; i<number_of_saved_lines; i++)
    {
      saved_text[i] = new char[MAX_TEXT_LINE_SIZE];
      saved_text[i][0] = '\0';
    }
    in_scrolling_text_mode = 1;
    redraw_both_text_and_graphics = 1;
}

void TAppWindow::init_scrolling_text()
{
    top_text_clip = 5;
    right_text_clip = 512;
    bottom_text_clip = 300;
    left_text_clip = 5;
    number_of_saved_lines =
        1 + ((bottom_text_clip - top_text_clip) /
                       string_height(" "));
    if (number_of_saved_lines > MAX_TEXT_LINES)
       number_of_saved_lines = MAX_TEXT_LINES;
    current_ring_buffer_start = 0;
    // Allocate storage for saved text lines:
    for (int i=0; i<number_of_saved_lines; i++)
    {
      saved_text[i] = new char[MAX_TEXT_LINE_SIZE+1];
      saved_text[i][0] = '\0';
    }
    in_scrolling_text_mode = 1;
    redraw_both_text_and_graphics = 0;
}

void TAppWindow::put_scrolling_text(char *str)
{
  if (bottom_text_clip != 0)
  {
    HRGN hClipRgn =
        CreateRectRgn(left_text_clip-3,
                      top_text_clip-3,
                      right_text_clip+7,
                      bottom_text_clip+5);
    SelectClipRgn(current_hDC, hClipRgn);
    RECT r, r2;
    SetRect(&r2, left_text_clip-2, top_text_clip,
            right_text_clip+6, bottom_text_clip+2);
    ScrollDC(current_hDC, 0, -string_height(" ")-2,
             &r2,&r2,NULL,NULL);
    SetRect(&r, left_text_clip -1,
            bottom_text_clip - string_height(" "),
            right_text_clip + 5, bottom_text_clip + 6);
    FillRect(current_hDC, &r, backgroundBrush);
    plot_string(left_text_clip + 1,
                bottom_text_clip - 2, str);
    DeleteObject(hClipRgn);
    r2.bottom += 2;
    r2.top -= 2;
    FrameRect(current_hDC, &r2, blackBrush);
    if (strlen(str) < 256)
    {
       char buf[257];
       sprintf(buf,"%s",str);
       buf[MAX_TEXT_LINE_SIZE] = '\0';
       saved_text[current_ring_buffer_start][0]='\0';
       strcat(saved_text[current_ring_buffer_start],
              (char far *)buf);
       current_ring_buffer_start++;
       if (current_ring_buffer_start >
           (number_of_saved_lines - 1))
       {
            current_ring_buffer_start = 0;
       }
    }
  }  else {
     Warning("Need to call TAppWindow::init_scrolling_text.");
  }
}

void TAppWindow::reset_scrolling_text()
{
  for (int i=0; i<MAX_TEXT_LINES; i++)
      saved_text[i][0] = '\0';
}

int TAppWindow::choose_file_to_read(char *prompt,
                                    char *extension,
                                    char *returned_filename)
{   cpEdit[0] = '\0';
    int len = strlen(prompt);
    if (len > 127) len = 127;
    for (int i=0; i<len; i++)
        cpPrompt[i] = prompt[i];
    cpPrompt[len] = '\0';
    len = strlen(extension);
    if (len > 12)  len = 12;
    for (i=0; i<len; i++)
        cpExtension[i] = extension[i];
    int status =
      DialogBox(Application::instanceHandle,
                "FileInBox", hWnd,lpfnDefaultFileInBox);
    for (i=0; cpEdit[i] != '\0'; i++)
        returned_filename[i] = cpEdit[i];
    returned_filename[i] = '\0';
    if (status == -1) return 1;  // error condition
    return 0;
}

int TAppWindow::choose_file_to_write(char *prompt,
                                     char *returned_filename)
{   cpEdit[0] = '\0';
    int len = strlen(prompt);
    if (len > 127) len = 127;
    for (int i=0; i<len; i++)
        cpPrompt[i] = prompt[i];
    cpPrompt[len] = '\0';
    int status =
      DialogBox(Application::instanceHandle,
                "FileOutBox",
                hWnd,
                lpfnDefaultFileOutBox);
    for (i=0; cpEdit[i] != '\0'; i++)
        returned_filename[i] = cpEdit[i];
    returned_filename[i] = '\0';
    if (status == -1) return 1;  // error condition
    return 0;
}

void Warning(char *buf)
{
    TAppWindow *current_window = Application::get_TAppWindow();
    MessageBeep(0);
    if (current_window != 0)
       current_window->do_edit(" ", buf);
}

void Warning(char *buf, int num)
{
    static char buffer[128];
    sprintf(buffer, buf, num);
    MessageBeep(0);
    TAppWindow *current_window = Application::get_TAppWindow();
    if (current_window != 0)
        current_window->do_edit(" ", buffer);
}

LONG APIENTRY WndProc(HWND hWnd,
                      UINT iMessage,
                      UINT wParam,
                      LONG lParam )
{
    // Pointer to the (C++ object that is the) window.
    TAppWindow *pWindow = Application::get_TAppWindow();
    if ( pWindow == 0 )
    {
        if ( iMessage == WM_CREATE )
        {
            LPCREATESTRUCT lpcs;

            lpcs = (LPCREATESTRUCT) lParam;
            pWindow = (TAppWindow *) lpcs->lpCreateParams;

            // Let the object perform whatever
            // initialization it needs for WM_CREATE in its own
            // WndProc:
            return pWindow->WndProc(iMessage, wParam, lParam);
        }
        else
            return DefWindowProc(hWnd, iMessage,
                                 wParam, lParam );
    }
    else
        return pWindow->WndProc(iMessage, wParam, lParam);
}


void private_setup();

extern int n_m_items;
extern char ** m_items;
extern char *m_name;    

//   The following Entry point function is called
//   automatically when your program is started under
//   a WIN32 or WIN32s environment:

int APIENTRY WinMain(HANDLE hInstance,
                     HANDLE hPrevInstance,
                     LPSTR /* lpCmdLine */,
                     int nCmdShow)
{
    Application::instanceHandle = hInstance;
    Application::applicationRegisteredFlag = hPrevInstance;
    Application::showWindowFlag = nCmdShow;
    if (Application::applicationRegisteredFlag == 0)
    {
        TAppWindow::registerWindow();
    }
    TAppWindow MainWnd;
    
    static CHAR szAppName [] = "Portable GUI";
    static WNDCLASS    wndclass;
    Application::showWindowFlag = nCmdShow;
    if (!hPrevInstance)
    {
         wndclass.style         = CS_HREDRAW | CS_VREDRAW;
         wndclass.lpfnWndProc   = (WNDPROC) WndProc;
         wndclass.cbClsExtra    = 0;
         wndclass.cbWndExtra    = 0;
         wndclass.hInstance     = hInstance;
         wndclass.hIcon         = LoadIcon(hInstance, szAppName);
         wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
         wndclass.hbrBackground = GetStockObject (BLACK_BRUSH);
         wndclass.lpszMenuName  = szAppName;
         wndclass.lpszClassName = szAppName;
         
         Application::instanceHandle = hInstance;

         if (!RegisterClass (&wndclass))
             return FALSE ;
     }

     private_setup();

     // Setup menu at execution time instead of using a
     // resource file (this enhances portability):

     //  Change the menu items text:
     HMENU hMenu = CreateMenu();
     HMENU hPopupMenu = CreateMenu();
     for (int mi=1; mi<(n_m_items + 1); mi++)
        AppendMenu(hPopupMenu, MF_STRING, mi, m_items[mi - 1]);
     AppendMenu(hMenu, MF_POPUP, (UINT)hPopupMenu, m_name);
     SetMenu(MainWnd.GetHandle(), hMenu);

     return Application::processEventMessages();
}

HANDLE Application::applicationRegisteredFlag = 0;
TAppWindow * Application::app_window = (TAppWindow *)NULL;
char Application::prompt_for_dialog[
                    Application::DIALOG_TEXT_LENGTH];
char Application::file_extension_for_dialog[
                    Application::DIALOG_TEXT_LENGTH];
char * Application::list_items_for_dialog[
                    Application::DIALOG_MAX_LIST_ITEMS];
int Application::number_of_dialog_list_items;
char Application::text_from_dialog[
                    Application::DIALOG_TEXT_LENGTH] = " ";

